#!/bin/sh
#
#/*******************************************************************
# * This file is part of the Emulex Linux Device Driver for         *
# * Fibre Channel Host Bus Adapters.                                *
# * Copyright (C) 2003-2005 Emulex.  All rights reserved.           *
# * EMULEX and SLI are trademarks of Emulex.                        *
# * www.emulex.com                                                  *
# *                                                                 *
# * This program is free software; you can redistribute it and/or   *
# * modify it under the terms of version 2 of the GNU General       *
# * Public License as published by the Free Software Foundation.    *
# * This program is distributed in the hope that it will be useful. *
# * ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND          *
# * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,  *
# * FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT, ARE      *
# * DISCLAIMED, EXCEPT TO THE EXTENT THAT SUCH DISCLAIMERS ARE HELD *
# * TO BE LEGALLY INVALID.  See the GNU General Public License for  *
# * more details, a copy of which can be found in the file COPYING  *
# * included with this package.                                     *
# *******************************************************************/
#
# scripts/set_target_timeout.sh Rev : 1.1
# This script is provided by Emulex to use with its 8.X linux device 
# driver for Light Pulse Fibre Channel adapters.
#
# This script changes the per scsi command timeout for all scsi devices
# per target per host.
# 
# This script runs on a specified host and specified target and modifies 
# the scsi device timeout for all luns (scsi devices).
#
# USAGE: The script is invoked with at least 3 arguments. The arguments
# specify the SCSI Host number, the target id managed by that host, and
# the new timeout value desired.  Since modifying scsi device timeouts
# is very target/load sensitive, the sys admin must execute this 
# script per host per target.
#
usage()
{
        echo ""
        echo "Usage: set_target_timeout [ host_num target_id cmd_timeout ]"
        echo "  where "
        echo "    host_num    : is the scsi host number assigned to the lpfc driver instance "
        echo "                  providing access to the luns."
	echo "    target_id   : is the target id of the target containing the scsi devices(luns)"
        echo "    cmd_timeout : is the new timeout value desired"
        echo ""
        echo "  Example:"
        echo "    set_target_timeout.sh 2 1 90  : Set the scsi command timeout on host 2, "
	echo "    target id 1 to 90 seconds for all luns contained on this target"
        echo ""
        echo ""
}

# Validate argument list
if [ $# -eq 0 -o "$1" = "--help" -o "$1" = "-h" ] ; then
        usage
        exit 1
fi

# Enter sysfs for the scsi device class first.
cd /sys/class/scsi_device/

# Change the per command timeout value on all luns
# for the given host, channel (assume 0), and target.

for i in `ls -d $1:0:$2*`
do
cd $i/device
echo "modifying device `pwd`"
echo "found timeout at value `cat timeout`"
echo $3 > timeout
echo "new timeout value is `cat timeout`"
cd ../..
done

